'''
"ai" funguje na principe score tabulky, cakal som ze bude omnoho menej inteligentnejsie ako je,
ale zase sa da lahsie oblbnut ako keby bol zalozeny na principe minimax ( teda aspon myslim ) 
je  z casti nahodne #* + som vytvoril druhu tabulku kde idu hodnoty viac k nule ak je potreba
vyhrat sa da, treba si len dat pozor na kraje a najma rohy 

zdroj pre tabulku http://www.intravisions.com/games/reversi/reversi_source.html


'''

import tkinter
import time
from random import randint

canvas = tkinter.Canvas(bg='white', width=500, height=500)
canvas.pack()

class Othello:

    class Ai:
        def __init__(self, m_suboru):
            self.tabulka = []
            with open(m_suboru) as subor:
                for riadok in subor.read().split('\n'):
                    self.tabulka.append([ int(i) for i in riadok.split()])

        def __repr__(self):
            vys = ''
            for riadok in self.tabulka:
                for znak in riadok:
                    vys += znak + ' ' 
                vys += '\n'
                
            return vys

        def vyhodnot(self, pole):
            pocet = 0
            #print(pole, 'pole')
            for p in pole:
                
                x, y = p
                #print(x,y, self.tabulka[x][y], 'hodnota')
                pocet += self.tabulka[x][y]

            return pocet

        def hraj(self, vyber):
            
            vysledok = None
            #print(vyber)
            hodnota = None
            for v in vyber.keys():
                
                if hodnota is None:
                    vysledok = v
                    hodnota = self.vyhodnot(vyber[v])
                    
                if self.vyhodnot(vyber[v]) > hodnota:
                    vysledok = v
                    hodnota = self.vyhodnot(vyber[v])
                elif self.vyhodnot(vyber[v]) == hodnota and vysledok is not None:
                    if len(vyber[vysledok]) < len(vyber[v]):
                        vysledok = v
                        hodnota = self.vyhodnot(vyber[v])
                else: 
                    if randint(1, 4) == 3: #*
                        #print('stasticko')
                        return vyber[vysledok]
            return vyber[vysledok]

            
    def __init__(self, meno_suboru1, meno_suboru2):
        canvas.bind('<ButtonPress>', self.hra)
        self.protihrac = self.Ai(meno_suboru2)
        self.teraz_hra_biely = False
        self.doska = [['.' for i in range(8)] for i in range(8)]
        
        #canvas.create_image(x, y, image=premenna)
        self.biely = tkinter.PhotoImage(file='biely.png')
        self.cierny = tkinter.PhotoImage(file='cierny.png')
        canvas.create_text(100, 450, text = '', tag = 'napis')
        #canvas.create_oval(140, 435, 165, 460, fill = 'white', tag = 'tag')
        canvas.create_rectangle(310, 460, 360, 440,  fill = 'white', tag = 'save')
        canvas.create_rectangle(360, 460, 410, 440,  fill = 'white', tag = 'load')
        canvas.create_rectangle(260, 460, 310, 440,  fill = 'white', tag = 'reset')
        canvas.create_text(335, 450, text = 'Save' )
        canvas.create_text(385, 450, text = 'Load' )
        canvas.create_text(285, 450, text = 'Reset' )
        self.load('zaciatocna pozicia.txt')
        self.vykresli()
        self.na_vyber(self.teraz_hra_biely)
        self.save()
        

    def __repr__(self):
        vys = ''
        for riadok in self.doska:
            for znak in riadok:
                vys += znak
            vys += '\n'
        return vys

    def vyber(self, event):
        print('klik', event.y//50, event.x//50)
        
    def vykresli(self):
        
        x = 50
        y = 50
        
        for i in range(8):
            for j in range(8):
                canvas.create_rectangle(x*j+10, y*i+10, x*j+x+10, y*i+y+10, fill='Tan' )
                #canvas.create_text(x*j+35, y*i+35, text = f'{i}, {j}') # pomocny potom zakomentovat
                if self.doska[i][j] == 'B':
                    #canvas.create_oval(x*j+15, y*i+15, x*j+x+5, y*i+y+5, fill='black' )
                    canvas.create_image(x*j+35, y*i+35,image = self.cierny)
                elif self.doska[i][j] == 'W':
                    #canvas.create_oval(x*j+15, y*i+15, x*j+x+5, y*i+y+5, fill='white' )
                    canvas.create_image(x*j+35, y*i+35,image = self.biely)
        '''
        if self.teraz_hra_biely:
            canvas.itemconfig('tag', fill='white')
        else:
            canvas.itemconfig('tag', fill='black')'''

    def save(self, meno_suboru='save.txt'):
        with open(meno_suboru, 'w') as subor:
            subor.write(str(int(self.teraz_hra_biely))+ '\n')
            subor.write(str(self))

            
    def load(self,meno_suboru='save.txt'):
        with open(meno_suboru, 'r') as subor:
            self.teraz_hra_biely = bool(int(subor.readline()))
            x = subor.read().strip().split()
            self.doska = [[i for i in k] for k in x]
        self.vykresli()
        self.na_vyber(self.teraz_hra_biely)

    def reset(self):
        self.load('zaciatocna pozicia.txt')
        
            
        
    def hladaj_zmenu(self,bod, biely = True):
        vys = [] # set() ak bude bugovat a pridavat viac krat co by nemalo
        stopka = 'B'
        if biely:
            stopka = 'W'
        
        def hore(bod, stopka):
            x, y = [*bod]
            tmp =  []
            x -= 1
            
            while x >= 0:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    x -= 1
            return []

        def dole(bod, stopka):
            x, y = [*bod]
            tmp =  []
            x += 1
            
            while x <= 7:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    x += 1
            return []

        def vpravo(bod, stopka):
            x, y = [*bod]
            tmp =  []
            y += 1
          
            while y <= 7:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    y += 1
            return []
            
        def vlavo(bod, stopka):
            x, y = [*bod]
            tmp =  []
            y -= 1
            
            while y >= 0:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    y -= 1
            return []
                
        def ho_vl(bod, stopka):
            x, y = [*bod]
            tmp =  []
            y -= 1
            x -= 1

            while y >= 0 and x >= 0:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    y -= 1
                    x -= 1
            return []
        
        def ho_vp(bod, stopka):
            x, y = [*bod]
            tmp =  []
            y += 1
            x -= 1

            while y <= 7 and x >= 0:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    y += 1
                    x -= 1
            return []

        def do_vp(bod, stopka):
            x, y = [*bod]
            tmp =  []
            y += 1
            x += 1
            while y <= 7 and x <= 7:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    
                    return tmp
                else:
                    tmp.append((x, y))
                    y += 1
                    x += 1
            return []

        def do_vl(bod, stopka):
            x, y = [*bod]
            tmp =  []
            y -= 1
            x += 1

            while y >= 0 and x <= 7:
                if self.doska[x][y] == '.':
                    return []
                elif self.doska[x][y] == stopka:
                    return tmp
                else:
                    tmp.append((x, y))
                    y -= 1
                    x += 1
            return []
        
        try:
            vys += hore(bod, stopka) +  dole(bod, stopka) + vpravo(bod, stopka) \
            + vlavo(bod, stopka) + do_vl(bod, stopka) + do_vp(bod, stopka) \
            + ho_vl(bod, stopka) + ho_vp(bod, stopka)
        except IndexError:
            return []
        return vys
    

    def zmen(self, pole, cierny = True):
        for sur in pole:
            if self.doska[sur[0]][sur[1]] == 'B':
                self.doska[sur[0]][sur[1]] = 'W'
            elif cierny:
                self.doska[sur[0]][sur[1]] = 'B'
            else:
                self.doska[sur[0]][sur[1]] = 'W'
        self.vykresli()
        

    def vstup_pre_pc(self):
        tmp = {}
        for vyber in self.na_vyber(True, True):
            if self.hladaj_zmenu(vyber):
                ziskane = self.hladaj_zmenu(vyber)
                ziskane.append(vyber)
                tmp[vyber] = ziskane
        return tmp

    
    def na_vyber(self, biely = True, pc = False):
        # tu by sa hodil graf kvoli susedom mozno
        vys = set()
        for x in range(8):
            for y in range(8):
                if self.doska[x][y] == '.':
                    if self.hladaj_zmenu((x, y), biely):
                        vys.add((x, y))
        if not pc:
            x = 50
            y = 50
            for sur in vys:
                i , j = sur
                
                canvas.create_rectangle(x*j+10, y*i+10, x*j+x+10, y*i+y+10, fill= 'Yellow' )
                #canvas.create_text(x*j+35, y*i+35, text = f'{i}, {j}')
                
        if self.teraz_hra_biely:
            canvas.itemconfig('tag', fill='white')
        else:
            canvas.itemconfig('tag', fill='black')
        
        return vys

    def vitaz(self):
        biele = str(self).count('W')
        cierne = str(self).count('B')
        return biele, cierne

    def hra(self, event):
        #print(event.y, event.x)
        if event.y >= 440 and event.y <= 460:
            if event.x > 260 and event.x <= 310:
                self.reset()
            elif event.x > 310 and event.x <= 360:
                self.save()
            elif event.x > 360 and event.x <= 410:
                self.load()
            

        x, y = event.y//50, event.x//50
        moznosti = self.na_vyber(self.teraz_hra_biely)
        
        if (x, y) in moznosti:
            #print(x, y)
            tieto_menim = self.hladaj_zmenu((x, y), self.teraz_hra_biely)
            self.doska[x][y] = 'B'
            self.zmen(tieto_menim)
            self.teraz_hra_biely = not self.teraz_hra_biely
            vstup = self.vstup_pre_pc()
            if vstup:
                pc = self.protihrac.hraj(vstup)
                #print(pc)
                self.zmen(pc, False)
            #print(self.teraz_hra_biely)
            self.teraz_hra_biely = not self.teraz_hra_biely

            if not self.na_vyber(self.teraz_hra_biely) and  not self.na_vyber(self.teraz_hra_biely):
            
                #canvas.delete('tag')
                biele, cierne = self.vitaz()
                if cierne == biele:
                    canvas.itemconfig('napis', text = f'Koniec hry. Je to remiza!')
                else:    
                    vyhral = 'biely.'
                    if cierne > biele:
                         vyhral = 'cierny.'
                    canvas.itemconfig('napis', text = f'Koniec hry. Vyhrava {vyhral} {biele} : {cierne}') 
                
#######################################################           

o = Othello('zaciatocna pozicia.txt', 'skore tab.txt')
#o = Othello('zaciatocna pozicia.txt', 'skore tab lahsia.txt')
